library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity Par2Ser is

   port(

	A12	: in std_logic;
	A13	: in std_logic;
	A14	: in std_logic;
	A15	: in std_logic;
	IO2	: in std_logic;
	PHI2	: in std_logic;
	ROML	: in std_logic;
	ROMH	: in std_logic;
	PC6	: in std_logic;
	PB5	: in std_logic;
	PB6	: in std_logic;
	clkdistin : in std_logic;

	clkdistout : out std_logic;
	CS6525 	: out std_logic;
	CS27128 : out std_logic;
	CS257	: out std_logic;
	GAME	: out std_logic;
	ROM_H	: out std_logic;
	ROM_L 	: out std_logic;

  	clk	: in std_logic;
  	NextS	: in std_logic;
 

	PD	: in std_logic_vector (3 downto 0);
  	Clear	: in std_logic;
  	SDO	: buffer std_logic;
	NextP 	: buffer std_logic 
	);

end Par2Ser;

architecture behavioral of Par2Ser is
	signal	count     : std_logic_vector (1 downto 0) ;
	signal NextSint  : bit;
	signal Reset     : bit;
	
	

begin

  	CS6525	<= not (	(not IO2) and PHI2 	);
	CS27128	<= not (	PB6 and A13 and A15	);
	CS257	<= not (	(not PB5) and A12 and A13 and (not A14)  );
	GAME	<= not (	(PC6 and PHI2) or ((not PB5) and (not PC6) and PHI2 and A12 and A13 and (not A14))  );
	ROM_H	<= not (	((not ROMH) and (not PB6)) or ((not PB5) and A12 and A13 and (not A14) and (not A15))    );
	ROM_L	<= not (	(not ROML) or (ROML and (not PB5) and A12 and A13 and (not A14) and A15)   );

	clkdistout  <= clkdistin;


  process (clk)
    begin

    if (clk'event and clk='1') then		
              
        if (Clear = '1') then				
			     count   	 <= "01";
			     SDO       <= '1';
			     NextP     <= '1';
				Reset 	<= '0'; 
		    end if;
		    
		    if (NextSint = '1' and Reset = '0' and Clear = '0') then  		        
		        case count is 
		          
		           when "11" =>   count       <= "00";
		                          Reset       <= '1';
		                          SDO         <= PD (3);
		                          NextP       <= '0';
		           
		           when "00" =>   count       <= "01";
		                          Reset       <= '1';
		                          SDO         <= PD (0);           
		             
		           when "01" =>   count       <= "10";
		                          Reset       <= '1';
		                          SDO         <= PD (1);
		                          NextP       <= '1';
		           
		           when "10" =>   count       <= "11";
		                          Reset       <= '1';
		                          SDO         <= PD (2);   
		           
		           when others =>  null; 
		        end case;
		     end if;
		     
		     if (Reset = '1') then          
		          Reset <= '0';
         end if; 
		         
     end if;
  end process;



  process (NextS, Reset, Clear)   -- SR Flip-Flop fr NextS, da NextS asynchron zu clk luft
  
  begin
  if (Clear = '1') then
  NextSint<='0';  
  elsif(NextS ='1' and Reset ='0' and Clear = '0') then 
  NextSint<='1';  
  elsif(NextS ='0' and Reset ='1' and Clear = '0') then 
  NextSint<='0'; 
  elsif(NextS ='0' and Reset ='0' and Clear = '0') then 
  NextSint<=NextSint;  
  end if; 
   
  end process; 


  
end behavioral;




